/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.explicit.locator.path.explicit.locator.path;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.explicit.locator.path.explicit.locator.path.Hop;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.explicit.locator.path.explicit.locator.path.HopKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class HopBuilder
implements Builder<Hop> {
    private SimpleAddress _address;
    private String _hopId;
    private Hop.LrsBits _lrsBits;
    private HopKey key;
    Map<Class<? extends Augmentation<Hop>>, Augmentation<Hop>> augmentation = Collections.emptyMap();

    public HopBuilder() {
    }

    public HopBuilder(Hop base) {
        Map aug;
        this.key = base.key();
        this._hopId = base.getHopId();
        this._address = base.getAddress();
        this._lrsBits = base.getLrsBits();
        if (base instanceof HopImpl) {
            HopImpl impl = (HopImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Hop>>, Augmentation<Hop>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Hop>>, Augmentation<Hop>>(aug);
        }
    }

    public HopKey key() {
        return this.key;
    }

    public SimpleAddress getAddress() {
        return this._address;
    }

    public String getHopId() {
        return this._hopId;
    }

    public Hop.LrsBits getLrsBits() {
        return this._lrsBits;
    }

    public <E$$ extends Augmentation<Hop>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public HopBuilder withKey(HopKey key) {
        this.key = key;
        return this;
    }

    public HopBuilder setAddress(SimpleAddress value) {
        this._address = value;
        return this;
    }

    public HopBuilder setHopId(String value) {
        this._hopId = value;
        return this;
    }

    public HopBuilder setLrsBits(Hop.LrsBits value) {
        this._lrsBits = value;
        return this;
    }

    public HopBuilder addAugmentation(Class<? extends Augmentation<Hop>> augmentationType, Augmentation<Hop> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Hop>>, Augmentation<Hop>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public HopBuilder removeAugmentation(Class<? extends Augmentation<Hop>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Hop build() {
        return new HopImpl(this);
    }

    private static final class HopImpl
    implements Hop {
        private final SimpleAddress _address;
        private final String _hopId;
        private final Hop.LrsBits _lrsBits;
        private final HopKey key;
        private Map<Class<? extends Augmentation<Hop>>, Augmentation<Hop>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        HopImpl(HopBuilder base) {
            this.key = base.key() != null ? base.key() : new HopKey(base.getHopId());
            this._hopId = this.key.getHopId();
            this._address = base.getAddress();
            this._lrsBits = base.getLrsBits();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Hop> getImplementedInterface() {
            return Hop.class;
        }

        @Override
        public HopKey key() {
            return this.key;
        }

        @Override
        public SimpleAddress getAddress() {
            return this._address;
        }

        @Override
        public String getHopId() {
            return this._hopId;
        }

        @Override
        public Hop.LrsBits getLrsBits() {
            return this._lrsBits;
        }

        public <E$$ extends Augmentation<Hop>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._hopId);
            result = 31 * result + Objects.hashCode(this._lrsBits);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Hop.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Hop other = (Hop)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._hopId, other.getHopId())) {
                return false;
            }
            if (!Objects.equals(this._lrsBits, other.getLrsBits())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                HopImpl otherImpl = (HopImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Hop>>, Augmentation<Hop>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Hop");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_address", (Object)this._address);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_hopId", (Object)this._hopId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_lrsBits", (Object)this._lrsBits);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

