/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.key.value.address;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.key.value.address.KeyValueAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeyValueAddressBuilder
implements Builder<KeyValueAddress> {
    private SimpleAddress _key;
    private SimpleAddress _value;
    Map<Class<? extends Augmentation<KeyValueAddress>>, Augmentation<KeyValueAddress>> augmentation = Collections.emptyMap();

    public KeyValueAddressBuilder() {
    }

    public KeyValueAddressBuilder(KeyValueAddress base) {
        Map aug;
        this._key = base.getKey();
        this._value = base.getValue();
        if (base instanceof KeyValueAddressImpl) {
            KeyValueAddressImpl impl = (KeyValueAddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<KeyValueAddress>>, Augmentation<KeyValueAddress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyValueAddress>>, Augmentation<KeyValueAddress>>(aug);
        }
    }

    public SimpleAddress getKey() {
        return this._key;
    }

    public SimpleAddress getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<KeyValueAddress>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public KeyValueAddressBuilder setKey(SimpleAddress value) {
        this._key = value;
        return this;
    }

    public KeyValueAddressBuilder setValue(SimpleAddress value) {
        this._value = value;
        return this;
    }

    public KeyValueAddressBuilder addAugmentation(Class<? extends Augmentation<KeyValueAddress>> augmentationType, Augmentation<KeyValueAddress> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyValueAddress>>, Augmentation<KeyValueAddress>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public KeyValueAddressBuilder removeAugmentation(Class<? extends Augmentation<KeyValueAddress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public KeyValueAddress build() {
        return new KeyValueAddressImpl(this);
    }

    private static final class KeyValueAddressImpl
    implements KeyValueAddress {
        private final SimpleAddress _key;
        private final SimpleAddress _value;
        private Map<Class<? extends Augmentation<KeyValueAddress>>, Augmentation<KeyValueAddress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        KeyValueAddressImpl(KeyValueAddressBuilder base) {
            this._key = base.getKey();
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<KeyValueAddress> getImplementedInterface() {
            return KeyValueAddress.class;
        }

        @Override
        public SimpleAddress getKey() {
            return this._key;
        }

        @Override
        public SimpleAddress getValue() {
            return this._value;
        }

        public <E$$ extends Augmentation<KeyValueAddress>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!KeyValueAddress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            KeyValueAddress other = (KeyValueAddress)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeyValueAddressImpl otherImpl = (KeyValueAddressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<KeyValueAddress>>, Augmentation<KeyValueAddress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"KeyValueAddress");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_key", (Object)this._key);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

