/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.nat.traversal;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.nat.traversal.NatTraversal;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NatTraversalBuilder
implements Builder<NatTraversal> {
    private Integer _etrUdpPort;
    private SimpleAddress _globalEtrRloc;
    private SimpleAddress _msRloc;
    private Integer _msUdpPort;
    private SimpleAddress _privateEtrRloc;
    private List<SimpleAddress> _rtrRlocs;
    Map<Class<? extends Augmentation<NatTraversal>>, Augmentation<NatTraversal>> augmentation = Collections.emptyMap();

    public NatTraversalBuilder() {
    }

    public NatTraversalBuilder(NatTraversal base) {
        Map aug;
        this._etrUdpPort = base.getEtrUdpPort();
        this._globalEtrRloc = base.getGlobalEtrRloc();
        this._msRloc = base.getMsRloc();
        this._msUdpPort = base.getMsUdpPort();
        this._privateEtrRloc = base.getPrivateEtrRloc();
        this._rtrRlocs = base.getRtrRlocs();
        if (base instanceof NatTraversalImpl) {
            NatTraversalImpl impl = (NatTraversalImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NatTraversal>>, Augmentation<NatTraversal>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NatTraversal>>, Augmentation<NatTraversal>>(aug);
        }
    }

    public Integer getEtrUdpPort() {
        return this._etrUdpPort;
    }

    public SimpleAddress getGlobalEtrRloc() {
        return this._globalEtrRloc;
    }

    public SimpleAddress getMsRloc() {
        return this._msRloc;
    }

    public Integer getMsUdpPort() {
        return this._msUdpPort;
    }

    public SimpleAddress getPrivateEtrRloc() {
        return this._privateEtrRloc;
    }

    public List<SimpleAddress> getRtrRlocs() {
        return this._rtrRlocs;
    }

    public <E$$ extends Augmentation<NatTraversal>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkEtrUdpPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NatTraversalBuilder setEtrUdpPort(Integer value) {
        if (value != null) {
            NatTraversalBuilder.checkEtrUdpPortRange(value);
        }
        this._etrUdpPort = value;
        return this;
    }

    public NatTraversalBuilder setGlobalEtrRloc(SimpleAddress value) {
        this._globalEtrRloc = value;
        return this;
    }

    public NatTraversalBuilder setMsRloc(SimpleAddress value) {
        this._msRloc = value;
        return this;
    }

    private static void checkMsUdpPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NatTraversalBuilder setMsUdpPort(Integer value) {
        if (value != null) {
            NatTraversalBuilder.checkMsUdpPortRange(value);
        }
        this._msUdpPort = value;
        return this;
    }

    public NatTraversalBuilder setPrivateEtrRloc(SimpleAddress value) {
        this._privateEtrRloc = value;
        return this;
    }

    public NatTraversalBuilder setRtrRlocs(List<SimpleAddress> values) {
        this._rtrRlocs = values;
        return this;
    }

    public NatTraversalBuilder addAugmentation(Class<? extends Augmentation<NatTraversal>> augmentationType, Augmentation<NatTraversal> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NatTraversal>>, Augmentation<NatTraversal>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NatTraversalBuilder removeAugmentation(Class<? extends Augmentation<NatTraversal>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NatTraversal build() {
        return new NatTraversalImpl(this);
    }

    private static final class NatTraversalImpl
    implements NatTraversal {
        private final Integer _etrUdpPort;
        private final SimpleAddress _globalEtrRloc;
        private final SimpleAddress _msRloc;
        private final Integer _msUdpPort;
        private final SimpleAddress _privateEtrRloc;
        private final List<SimpleAddress> _rtrRlocs;
        private Map<Class<? extends Augmentation<NatTraversal>>, Augmentation<NatTraversal>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NatTraversalImpl(NatTraversalBuilder base) {
            this._etrUdpPort = base.getEtrUdpPort();
            this._globalEtrRloc = base.getGlobalEtrRloc();
            this._msRloc = base.getMsRloc();
            this._msUdpPort = base.getMsUdpPort();
            this._privateEtrRloc = base.getPrivateEtrRloc();
            this._rtrRlocs = base.getRtrRlocs();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NatTraversal> getImplementedInterface() {
            return NatTraversal.class;
        }

        @Override
        public Integer getEtrUdpPort() {
            return this._etrUdpPort;
        }

        @Override
        public SimpleAddress getGlobalEtrRloc() {
            return this._globalEtrRloc;
        }

        @Override
        public SimpleAddress getMsRloc() {
            return this._msRloc;
        }

        @Override
        public Integer getMsUdpPort() {
            return this._msUdpPort;
        }

        @Override
        public SimpleAddress getPrivateEtrRloc() {
            return this._privateEtrRloc;
        }

        @Override
        public List<SimpleAddress> getRtrRlocs() {
            return this._rtrRlocs;
        }

        public <E$$ extends Augmentation<NatTraversal>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._etrUdpPort);
            result = 31 * result + Objects.hashCode(this._globalEtrRloc);
            result = 31 * result + Objects.hashCode(this._msRloc);
            result = 31 * result + Objects.hashCode(this._msUdpPort);
            result = 31 * result + Objects.hashCode(this._privateEtrRloc);
            result = 31 * result + Objects.hashCode(this._rtrRlocs);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NatTraversal.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NatTraversal other = (NatTraversal)obj;
            if (!Objects.equals(this._etrUdpPort, other.getEtrUdpPort())) {
                return false;
            }
            if (!Objects.equals(this._globalEtrRloc, other.getGlobalEtrRloc())) {
                return false;
            }
            if (!Objects.equals(this._msRloc, other.getMsRloc())) {
                return false;
            }
            if (!Objects.equals(this._msUdpPort, other.getMsUdpPort())) {
                return false;
            }
            if (!Objects.equals(this._privateEtrRloc, other.getPrivateEtrRloc())) {
                return false;
            }
            if (!Objects.equals(this._rtrRlocs, other.getRtrRlocs())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NatTraversalImpl otherImpl = (NatTraversalImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NatTraversal>>, Augmentation<NatTraversal>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NatTraversal");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_etrUdpPort", (Object)this._etrUdpPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_globalEtrRloc", (Object)this._globalEtrRloc);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_msRloc", (Object)this._msRloc);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_msUdpPort", (Object)this._msUdpPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_privateEtrRloc", (Object)this._privateEtrRloc);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_rtrRlocs", this._rtrRlocs);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

