/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.source.dest.key;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.SimpleAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.lisp.address.types.rev151105.lisp.address.address.source.dest.key.SourceDestKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SourceDestKeyBuilder
implements Builder<SourceDestKey> {
    private SimpleAddress _dest;
    private SimpleAddress _source;
    Map<Class<? extends Augmentation<SourceDestKey>>, Augmentation<SourceDestKey>> augmentation = Collections.emptyMap();

    public SourceDestKeyBuilder() {
    }

    public SourceDestKeyBuilder(SourceDestKey base) {
        Map aug;
        this._dest = base.getDest();
        this._source = base.getSource();
        if (base instanceof SourceDestKeyImpl) {
            SourceDestKeyImpl impl = (SourceDestKeyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SourceDestKey>>, Augmentation<SourceDestKey>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SourceDestKey>>, Augmentation<SourceDestKey>>(aug);
        }
    }

    public SimpleAddress getDest() {
        return this._dest;
    }

    public SimpleAddress getSource() {
        return this._source;
    }

    public <E$$ extends Augmentation<SourceDestKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SourceDestKeyBuilder setDest(SimpleAddress value) {
        this._dest = value;
        return this;
    }

    public SourceDestKeyBuilder setSource(SimpleAddress value) {
        this._source = value;
        return this;
    }

    public SourceDestKeyBuilder addAugmentation(Class<? extends Augmentation<SourceDestKey>> augmentationType, Augmentation<SourceDestKey> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SourceDestKey>>, Augmentation<SourceDestKey>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SourceDestKeyBuilder removeAugmentation(Class<? extends Augmentation<SourceDestKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SourceDestKey build() {
        return new SourceDestKeyImpl(this);
    }

    private static final class SourceDestKeyImpl
    implements SourceDestKey {
        private final SimpleAddress _dest;
        private final SimpleAddress _source;
        private Map<Class<? extends Augmentation<SourceDestKey>>, Augmentation<SourceDestKey>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SourceDestKeyImpl(SourceDestKeyBuilder base) {
            this._dest = base.getDest();
            this._source = base.getSource();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SourceDestKey> getImplementedInterface() {
            return SourceDestKey.class;
        }

        @Override
        public SimpleAddress getDest() {
            return this._dest;
        }

        @Override
        public SimpleAddress getSource() {
            return this._source;
        }

        public <E$$ extends Augmentation<SourceDestKey>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dest);
            result = 31 * result + Objects.hashCode(this._source);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SourceDestKey.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SourceDestKey other = (SourceDestKey)obj;
            if (!Objects.equals(this._dest, other.getDest())) {
                return false;
            }
            if (!Objects.equals(this._source, other.getSource())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SourceDestKeyImpl otherImpl = (SourceDestKeyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SourceDestKey>>, Augmentation<SourceDestKey>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SourceDestKey");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dest", (Object)this._dest);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_source", (Object)this._source);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

