/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.LongAdder;
import org.opendaylight.yangtools.util.ExecutorServiceUtil;

public class CountingRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final LongAdder rejectedTaskCounter = new LongAdder();
    private final RejectedExecutionHandler delegate;

    public CountingRejectedExecutionHandler(RejectedExecutionHandler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
        this.rejectedTaskCounter.increment();
        this.delegate.rejectedExecution(task, executor);
    }

    public long getRejectedTaskCount() {
        return this.rejectedTaskCounter.sum();
    }

    public static CountingRejectedExecutionHandler newCallerRunsPolicy() {
        return new CountingRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static CountingRejectedExecutionHandler newAbortPolicy() {
        return new CountingRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
    }

    public static CountingRejectedExecutionHandler newCallerWaitsPolicy() {
        return new CountingRejectedExecutionHandler(ExecutorServiceUtil.waitInQueueExecutionHandler());
    }
}

