/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.concurrent.ListenerNotificationQueueStats;
import org.opendaylight.yangtools.util.concurrent.NotificationManager;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManagerMXBean;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManagerMXBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedNotificationManager<L, N>
implements NotificationManager<L, N> {
    private static final Logger LOG = LoggerFactory.getLogger(QueuedNotificationManager.class);
    private static final int MAX_NOTIFICATION_OFFER_MINUTES = 10;
    private static final long GIVE_UP_NANOS = TimeUnit.MINUTES.toNanos(10L);
    private static final long TASK_WAIT_NANOS = TimeUnit.MILLISECONDS.toNanos(10L);
    private final ConcurrentMap<ListenerKey<L>, NotificationTask> listenerCache = new ConcurrentHashMap<ListenerKey<L>, NotificationTask>();
    private final @NonNull QueuedNotificationManagerMXBean mxBean = new QueuedNotificationManagerMXBeanImpl(this);
    private final @NonNull BatchedInvoker<L, N> listenerInvoker;
    private final @NonNull Executor executor;
    private final @NonNull String name;
    private final int maxQueueCapacity;

    private QueuedNotificationManager(@NonNull Executor executor, @NonNull BatchedInvoker<L, N> listenerInvoker, int maxQueueCapacity, @NonNull String name) {
        Preconditions.checkArgument((maxQueueCapacity > 0 ? 1 : 0) != 0, (String)"Invalid maxQueueCapacity %s must be > 0", (int)maxQueueCapacity);
        this.executor = Objects.requireNonNull(executor);
        this.listenerInvoker = Objects.requireNonNull(listenerInvoker);
        this.maxQueueCapacity = maxQueueCapacity;
        this.name = Objects.requireNonNull(name);
    }

    @Deprecated
    public QueuedNotificationManager(@NonNull Executor executor, @NonNull Invoker<L, N> listenerInvoker, int maxQueueCapacity, @NonNull String name) {
        this(executor, (L listener, Collection<N> notifications) -> notifications.forEach(n -> {
            try {
                listenerInvoker.invokeListener(listener, n);
            }
            catch (Exception e) {
                LOG.error("{}: Error notifying listener {} with {}", new Object[]{name, listener, n, e});
            }
        }), maxQueueCapacity, name);
        Objects.requireNonNull(listenerInvoker);
    }

    public static <L, N> QueuedNotificationManager<L, N> create(@NonNull Executor executor, @NonNull BatchedInvoker<L, N> listenerInvoker, int maxQueueCapacity, @NonNull String name) {
        return new QueuedNotificationManager<L, N>(executor, listenerInvoker, maxQueueCapacity, name);
    }

    public int getMaxQueueCapacity() {
        return this.maxQueueCapacity;
    }

    public @NonNull QueuedNotificationManagerMXBean getMXBean() {
        return this.mxBean;
    }

    public @NonNull Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void submitNotification(L listener, N notification) {
        if (notification != null) {
            this.submitNotifications(listener, Collections.singletonList(notification));
        }
    }

    @Override
    public void submitNotifications(L listener, Iterable<N> notifications) {
        if (notifications == null || listener == null) {
            return;
        }
        LOG.trace("{}: submitNotifications for listener {}: {}", new Object[]{this.name, listener, notifications});
        ListenerKey<L> key = new ListenerKey<L>(listener);
        try {
            Iterator<N> it = notifications.iterator();
            while (true) {
                boolean completed;
                NotificationTask task;
                if ((task = (NotificationTask)this.listenerCache.get(key)) == null) {
                    NotificationTask newTask = new NotificationTask(key, it);
                    task = this.listenerCache.putIfAbsent(key, newTask);
                    if (task == null) {
                        this.runTask(listener, newTask);
                        break;
                    }
                    it = newTask.recoverItems();
                }
                if (completed = task.submitNotifications(it)) break;
                NotificationTask newTask = new NotificationTask(key, it);
                if (this.listenerCache.replace(key, task, newTask)) {
                    this.runTask(listener, newTask);
                    break;
                }
                it = newTask.recoverItems();
                LOG.debug("{}: retrying task queueing for {}", (Object)this.name, listener);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{}: Interrupted trying to add to {} listener's queue", (Object)this.name, listener);
        }
        LOG.trace("{}: submitNotifications done for listener {}", (Object)this.name, listener);
    }

    public List<ListenerNotificationQueueStats> getListenerNotificationQueueStats() {
        return this.listenerCache.values().stream().map(t -> new ListenerNotificationQueueStats(((NotificationTask)t).listenerKey.toString(), t.size())).collect(Collectors.toList());
    }

    private void runTask(L listener, NotificationTask task) {
        LOG.debug("{}: Submitting NotificationTask for listener {}", (Object)this.name, listener);
        this.executor.execute(task);
    }

    static /* synthetic */ long access$000() {
        return GIVE_UP_NANOS;
    }

    static /* synthetic */ int access$100(QueuedNotificationManager x0) {
        return x0.maxQueueCapacity;
    }

    private class NotificationTask
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final Condition notEmpty = this.lock.newCondition();
        private final Condition notFull = this.lock.newCondition();
        private final @NonNull ListenerKey<L> listenerKey;
        @GuardedBy(value="lock")
        private final Queue<N> queue = new ArrayDeque();
        @GuardedBy(value="lock")
        private boolean exiting;

        NotificationTask(@NonNull ListenerKey<L> listenerKey, Iterator<N> notifications) {
            this.listenerKey = Objects.requireNonNull(listenerKey);
            while (notifications.hasNext()) {
                this.queue.add(notifications.next());
            }
        }

        @NonNull Iterator<N> recoverItems() {
            return this.queue.iterator();
        }

        int size() {
            this.lock.lock();
            try {
                int n = this.queue.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * Unable to fully structure code
         */
        boolean submitNotifications(@NonNull Iterator<N> notifications) throws InterruptedException {
            start = System.nanoTime();
            deadline = start + QueuedNotificationManager.access$000();
            this.lock.lock();
            try {
                canWait = deadline - System.nanoTime();
                block6: while (true) {
                    if (this.exiting) {
                        var8_5 = false;
                        return var8_5;
                    }
                    avail = QueuedNotificationManager.access$100(QueuedNotificationManager.this) - this.queue.size();
                    if (avail <= 0) {
                        if (canWait <= 0L) {
                            QueuedNotificationManager.access$300().warn("{}: Failed to offer notifications {} to the queue for listener {}. Exceededmaximum allowable time of {} minutes; the listener is likely in an unrecoverablestate (deadlock or endless loop). ", new Object[]{QueuedNotificationManager.access$200(QueuedNotificationManager.this), ImmutableList.copyOf(notifications), this.listenerKey, 10});
                            var9_6 = true;
                            return var9_6;
                        }
                        canWait = this.notFull.awaitNanos(canWait);
                        continue;
                    }
                    i = 0;
                    while (true) {
                        if (i < avail) ** break;
                        continue block6;
                        if (!notifications.hasNext()) {
                            this.notEmpty.signal();
                            var10_7 = true;
                            return var10_7;
                        }
                        this.queue.add(notifications.next());
                        ++i;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        @GuardedBy(value="lock")
        private boolean waitForQueue() {
            long timeout = TASK_WAIT_NANOS;
            while (this.queue.isEmpty()) {
                if (timeout <= 0L) {
                    return false;
                }
                try {
                    timeout = this.notEmpty.awaitNanos(timeout);
                }
                catch (InterruptedException e) {
                    LOG.debug("{}: Interrupted trying to remove from {} listener's queue", (Object)QueuedNotificationManager.this.name, this.listenerKey);
                    return false;
                }
            }
            return true;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ImmutableList notifications;
                    this.lock.lock();
                    try {
                        if (!this.waitForQueue()) {
                            this.exiting = true;
                            break;
                        }
                        notifications = ImmutableList.copyOf(this.queue);
                        this.queue.clear();
                        this.notFull.signalAll();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    this.invokeListener((Collection)notifications);
                }
            }
            finally {
                QueuedNotificationManager.this.listenerCache.remove(this.listenerKey, this);
            }
        }

        private void invokeListener(@NonNull Collection<N> notifications) {
            LOG.debug("{}: Invoking listener {} with notification: {}", new Object[]{QueuedNotificationManager.this.name, this.listenerKey, notifications});
            try {
                QueuedNotificationManager.this.listenerInvoker.invokeListener(this.listenerKey.getListener(), notifications);
            }
            catch (Exception e) {
                LOG.error("{}: Error notifying listener {} with {}", new Object[]{QueuedNotificationManager.this.name, this.listenerKey, notifications, e});
            }
        }
    }

    private static final class ListenerKey<L> {
        private final @NonNull L listener;

        ListenerKey(L listener) {
            this.listener = Objects.requireNonNull(listener);
        }

        @NonNull L getListener() {
            return this.listener;
        }

        public int hashCode() {
            return System.identityHashCode(this.listener);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ListenerKey && this.listener == ((ListenerKey)obj).listener;
        }

        public String toString() {
            return this.listener.toString();
        }
    }

    @FunctionalInterface
    public static interface BatchedInvoker<L, N> {
        public void invokeListener(@NonNull L var1, @NonNull Collection<? extends N> var2);
    }

    @Deprecated
    @FunctionalInterface
    public static interface Invoker<L, N> {
        public void invokeListener(L var1, N var2);
    }
}

