/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.yanglib.impl.rev141210;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.yanglib.impl.rev141210.YanglibConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class YanglibConfigBuilder
implements Builder<YanglibConfig> {
    private String _bindingAddr;
    private Long _bindingPort;
    private String _cacheFolder;
    Map<Class<? extends Augmentation<YanglibConfig>>, Augmentation<YanglibConfig>> augmentation = Collections.emptyMap();

    public YanglibConfigBuilder() {
    }

    public YanglibConfigBuilder(YanglibConfig base) {
        Map aug;
        this._bindingAddr = base.getBindingAddr();
        this._bindingPort = base.getBindingPort();
        this._cacheFolder = base.getCacheFolder();
        if (base instanceof YanglibConfigImpl) {
            YanglibConfigImpl impl = (YanglibConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<YanglibConfig>>, Augmentation<YanglibConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YanglibConfig>>, Augmentation<YanglibConfig>>(aug);
        }
    }

    public String getBindingAddr() {
        return this._bindingAddr;
    }

    public Long getBindingPort() {
        return this._bindingPort;
    }

    public String getCacheFolder() {
        return this._cacheFolder;
    }

    public <E$$ extends Augmentation<YanglibConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public YanglibConfigBuilder setBindingAddr(String value) {
        this._bindingAddr = value;
        return this;
    }

    private static void checkBindingPortRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public YanglibConfigBuilder setBindingPort(Long value) {
        if (value != null) {
            YanglibConfigBuilder.checkBindingPortRange(value);
        }
        this._bindingPort = value;
        return this;
    }

    public YanglibConfigBuilder setCacheFolder(String value) {
        this._cacheFolder = value;
        return this;
    }

    public YanglibConfigBuilder addAugmentation(Class<? extends Augmentation<YanglibConfig>> augmentationType, Augmentation<YanglibConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<YanglibConfig>>, Augmentation<YanglibConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public YanglibConfigBuilder removeAugmentation(Class<? extends Augmentation<YanglibConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public YanglibConfig build() {
        return new YanglibConfigImpl(this);
    }

    private static final class YanglibConfigImpl
    implements YanglibConfig {
        private final String _bindingAddr;
        private final Long _bindingPort;
        private final String _cacheFolder;
        private Map<Class<? extends Augmentation<YanglibConfig>>, Augmentation<YanglibConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        YanglibConfigImpl(YanglibConfigBuilder base) {
            this._bindingAddr = base.getBindingAddr();
            this._bindingPort = base.getBindingPort();
            this._cacheFolder = base.getCacheFolder();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<YanglibConfig> getImplementedInterface() {
            return YanglibConfig.class;
        }

        @Override
        public String getBindingAddr() {
            return this._bindingAddr;
        }

        @Override
        public Long getBindingPort() {
            return this._bindingPort;
        }

        @Override
        public String getCacheFolder() {
            return this._cacheFolder;
        }

        public <E$$ extends Augmentation<YanglibConfig>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bindingAddr);
            result = 31 * result + Objects.hashCode(this._bindingPort);
            result = 31 * result + Objects.hashCode(this._cacheFolder);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!YanglibConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            YanglibConfig other = (YanglibConfig)obj;
            if (!Objects.equals(this._bindingAddr, other.getBindingAddr())) {
                return false;
            }
            if (!Objects.equals(this._bindingPort, other.getBindingPort())) {
                return false;
            }
            if (!Objects.equals(this._cacheFolder, other.getCacheFolder())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                YanglibConfigImpl otherImpl = (YanglibConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<YanglibConfig>>, Augmentation<YanglibConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"YanglibConfig");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bindingAddr", (Object)this._bindingAddr);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bindingPort", (Object)this._bindingPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_cacheFolder", (Object)this._cacheFolder);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

