/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yanglib.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.opendaylight.yanglib.api.YangLibService;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangLibServiceImpl
implements YangLibService {
    private static final Logger LOG = LoggerFactory.getLogger(YangLibServiceImpl.class);
    private final SchemaRepository schemaRepository;

    public YangLibServiceImpl(SchemaRepository schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    @Override
    public String getSchema(String name, String revision) {
        Preconditions.checkNotNull((Object)this.schemaRepository, (Object)"Schema repository is not initialized");
        LOG.debug("Attempting load for schema source {}:{}", (Object)name, (Object)revision);
        RevisionSourceIdentifier sourceId = RevisionSourceIdentifier.create((String)name, (Revision)(revision.isEmpty() ? null : Revision.of((String)revision)));
        ListenableFuture sourceFuture = this.schemaRepository.getSchemaSource((SourceIdentifier)sourceId, YangTextSchemaSource.class);
        try {
            YangTextSchemaSource source = (YangTextSchemaSource)sourceFuture.get();
            return new String(ByteStreams.toByteArray((InputStream)source.openStream()), Charset.defaultCharset());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Unable to get schema " + sourceId, e);
        }
    }
}

