/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.openwebbeans;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class SafeServiceLoader {
    private ClassLoader classLoader;

    public SafeServiceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> List<T> load(String serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        String resourceName = "/META-INF/services/" + serviceType;
        try {
            Enumeration<URL> resources = this.classLoader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                List<String> classNames = this.parse(url);
                for (String className : classNames) {
                    Class<T> klass = this.loadClassIfVisible(className, this.classLoader);
                    if (klass == null) continue;
                    T service = klass.newInstance();
                    services.add(service);
                }
            }
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc);
        }
        return services;
    }

    private <T> Class<T> loadClassIfVisible(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parse(URL url) throws IOException {
        BufferedReader reader = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String line;
            InputStream is = url.openStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                this.parseLine(names, line);
            }
            this.closeSilently(reader);
        }
        catch (Throwable throwable) {
            this.closeSilently(reader);
            throw throwable;
        }
        return names;
    }

    private void closeSilently(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseLine(List<String> names, String line) {
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            line = line.substring(0, commentPos);
        }
        if (!(line = line.trim()).isEmpty() && !names.contains(line)) {
            names.add(line);
        }
    }
}

