/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.openwebbeans.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.ops4j.pax.cdi.openwebbeans.impl.InstanceManager;
import org.ops4j.pax.cdi.spi.AbstractCdiContainer;
import org.ops4j.pax.cdi.spi.CdiClassLoaderBuilderCustomizer;
import org.ops4j.pax.cdi.spi.util.Exceptions;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWebBeansCdiContainer
extends AbstractCdiContainer {
    private static Logger log = LoggerFactory.getLogger(OpenWebBeansCdiContainer.class);
    private ContainerLifecycle lifecycle;
    private InstanceManager instanceManager;
    private WebBeansContext context;

    public OpenWebBeansCdiContainer(Bundle ownBundle, Bundle extendedBundle, Collection<Bundle> extensionBundles) {
        super(extendedBundle, extensionBundles, Collections.singletonList(ownBundle));
        log.debug("creating OpenWebBeans CDI container for bundle {}", (Object)extendedBundle);
    }

    private WebBeansContext createWebBeansContext(final Object environment) {
        try {
            return (WebBeansContext)this.doWithClassLoader(new Callable<WebBeansContext>(){

                @Override
                public WebBeansContext call() throws Exception {
                    WebBeansContext webBeansContext = WebBeansContext.currentInstance();
                    OpenWebBeansCdiContainer.this.lifecycle = (ContainerLifecycle)webBeansContext.getService(ContainerLifecycle.class);
                    OpenWebBeansCdiContainer.this.lifecycle.startApplication(environment);
                    return webBeansContext;
                }
            });
        }
        catch (Exception exc) {
            throw Exceptions.unchecked((Throwable)exc);
        }
    }

    protected void doStart(Object environment) {
        this.context = this.createWebBeansContext(environment);
        if (log.isDebugEnabled()) {
            for (Bean bean : this.context.getBeanManagerImpl().getBeans()) {
                log.debug("  {}", (Object)bean);
            }
        }
    }

    protected void doStop() {
        try {
            this.doWithClassLoader(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (OpenWebBeansCdiContainer.this.lifecycle != null) {
                        OpenWebBeansCdiContainer.this.lifecycle.stopApplication((Object)OpenWebBeansCdiContainer.this.getContextClassLoader());
                    }
                    return null;
                }
            });
        }
        catch (Exception exc) {
            throw Exceptions.unchecked((Throwable)exc);
        }
    }

    public Event<Object> getEvent() {
        return this.getInstanceManager().getEvent();
    }

    public BeanManager getBeanManager() {
        return this.lifecycle.getBeanManager();
    }

    public Instance<Object> getInstance() {
        return this.getInstanceManager().getInstance();
    }

    private InstanceManager getInstanceManager() {
        if (this.instanceManager == null) {
            BeanManager beanManager = this.getBeanManager();
            this.instanceManager = new InstanceManager();
            AnnotatedType annotatedType = beanManager.createAnnotatedType(InstanceManager.class);
            InjectionTarget target = beanManager.createInjectionTarget(annotatedType);
            CreationalContext cc = beanManager.createCreationalContext(null);
            target.inject((Object)this.instanceManager, cc);
        }
        return this.instanceManager;
    }

    public <T> T unwrap(Class<T> wrappedClass) {
        if (wrappedClass.isAssignableFrom(WebBeansContext.class)) {
            return wrappedClass.cast(this.context);
        }
        if (wrappedClass.isAssignableFrom(ContainerLifecycle.class)) {
            return wrappedClass.cast(this.lifecycle);
        }
        if (wrappedClass.isAssignableFrom(CdiClassLoaderBuilderCustomizer.class)) {
            return wrappedClass.cast((Object)this);
        }
        return null;
    }

    public void startContext(Class<? extends Annotation> scope) {
        ContextsService contextsService = (ContextsService)this.context.getService(ContextsService.class);
        contextsService.startContext(scope, null);
    }

    public void stopContext(Class<? extends Annotation> scope) {
        ContextsService contextsService = (ContextsService)this.context.getService(ContextsService.class);
        contextsService.endContext(scope, null);
    }
}

