/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.apache.openjpa.lib.meta.FileMetaDataIterator;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIteratorChain;
import org.apache.openjpa.lib.meta.ZipFileMetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.StringUtil;

public class ClasspathMetaDataIterator
extends MetaDataIteratorChain {
    public ClasspathMetaDataIterator() throws IOException {
        this((String[])null, (MetaDataFilter)null);
    }

    public ClasspathMetaDataIterator(String[] dirs, MetaDataFilter filter) throws IOException {
        Properties props = AccessController.doPrivileged(J2DoPrivHelper.getPropertiesAction());
        String path = props.getProperty("java.class.path");
        String[] tokens = StringUtil.split(path, props.getProperty("path.separator"), 0);
        for (int i = 0; i < tokens.length; ++i) {
            File file;
            if (dirs != null && dirs.length != 0 && !ClasspathMetaDataIterator.endsWith(tokens[i], dirs) || !AccessController.doPrivileged(J2DoPrivHelper.existsAction(file = new File(tokens[i]))).booleanValue()) continue;
            if (AccessController.doPrivileged(J2DoPrivHelper.isDirectoryAction(file)).booleanValue()) {
                this.addIterator(new FileMetaDataIterator(file, filter));
                continue;
            }
            if (!tokens[i].endsWith(".jar")) continue;
            try {
                ZipFile zFile = AccessController.doPrivileged(J2DoPrivHelper.newZipFileAction(file));
                this.addIterator(new ZipFileMetaDataIterator(zFile, filter));
                continue;
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
    }

    private static boolean endsWith(String token, String[] suffs) {
        for (int i = 0; i < suffs.length; ++i) {
            if (!token.endsWith(suffs[i])) continue;
            return true;
        }
        return false;
    }
}

