/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum SwitchingCapabilities implements Enumeration
{
    PSC1(1, "PSC-1"),
    PSC2(2, "PSC-2"),
    PSC3(3, "PSC-3"),
    PSC4(4, "PSC-4"),
    L2SC(51, "L2SC"),
    TDM(100, "TDM"),
    LSC(150, "LSC"),
    FSC(200, "FSC");

    private static final Map<String, SwitchingCapabilities> NAME_MAP;
    private static final Map<Integer, SwitchingCapabilities> VALUE_MAP;
    private final String name;
    private final int value;

    private SwitchingCapabilities(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<SwitchingCapabilities> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static SwitchingCapabilities forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (SwitchingCapabilities enumItem : SwitchingCapabilities.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

