/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.SwitchingCapabilities;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes.InterfaceSwitchingCapabilities;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes.InterfaceSwitchingCapabilitiesKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.MaxLspBandwidth;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.PacketSwitchCapable;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.TimeDivisionMultiplexCapable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InterfaceSwitchingCapabilitiesBuilder
implements Builder<InterfaceSwitchingCapabilities> {
    private Short _encoding;
    private List<MaxLspBandwidth> _maxLspBandwidth;
    private PacketSwitchCapable _packetSwitchCapable;
    private SwitchingCapabilities _switchingCapability;
    private TimeDivisionMultiplexCapable _timeDivisionMultiplexCapable;
    private InterfaceSwitchingCapabilitiesKey key;
    Map<Class<? extends Augmentation<InterfaceSwitchingCapabilities>>, Augmentation<InterfaceSwitchingCapabilities>> augmentation = Collections.emptyMap();

    public InterfaceSwitchingCapabilitiesBuilder() {
    }

    public InterfaceSwitchingCapabilitiesBuilder(InterfaceSwitchingCapabilities base) {
        Map aug;
        this.key = base.key();
        this._switchingCapability = base.getSwitchingCapability();
        this._encoding = base.getEncoding();
        this._maxLspBandwidth = base.getMaxLspBandwidth();
        this._packetSwitchCapable = base.getPacketSwitchCapable();
        this._timeDivisionMultiplexCapable = base.getTimeDivisionMultiplexCapable();
        if (base instanceof InterfaceSwitchingCapabilitiesImpl) {
            InterfaceSwitchingCapabilitiesImpl impl = (InterfaceSwitchingCapabilitiesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceSwitchingCapabilities>>, Augmentation<InterfaceSwitchingCapabilities>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceSwitchingCapabilities>>, Augmentation<InterfaceSwitchingCapabilities>>(aug);
        }
    }

    public InterfaceSwitchingCapabilitiesKey key() {
        return this.key;
    }

    public Short getEncoding() {
        return this._encoding;
    }

    public List<MaxLspBandwidth> getMaxLspBandwidth() {
        return this._maxLspBandwidth;
    }

    public PacketSwitchCapable getPacketSwitchCapable() {
        return this._packetSwitchCapable;
    }

    public SwitchingCapabilities getSwitchingCapability() {
        return this._switchingCapability;
    }

    public TimeDivisionMultiplexCapable getTimeDivisionMultiplexCapable() {
        return this._timeDivisionMultiplexCapable;
    }

    public <E$$ extends Augmentation<InterfaceSwitchingCapabilities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public InterfaceSwitchingCapabilitiesBuilder withKey(InterfaceSwitchingCapabilitiesKey key) {
        this.key = key;
        return this;
    }

    private static void checkEncodingRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public InterfaceSwitchingCapabilitiesBuilder setEncoding(Short value) {
        if (value != null) {
            InterfaceSwitchingCapabilitiesBuilder.checkEncodingRange(value);
        }
        this._encoding = value;
        return this;
    }

    public InterfaceSwitchingCapabilitiesBuilder setMaxLspBandwidth(List<MaxLspBandwidth> values) {
        this._maxLspBandwidth = values;
        return this;
    }

    public InterfaceSwitchingCapabilitiesBuilder setPacketSwitchCapable(PacketSwitchCapable value) {
        this._packetSwitchCapable = value;
        return this;
    }

    public InterfaceSwitchingCapabilitiesBuilder setSwitchingCapability(SwitchingCapabilities value) {
        this._switchingCapability = value;
        return this;
    }

    public InterfaceSwitchingCapabilitiesBuilder setTimeDivisionMultiplexCapable(TimeDivisionMultiplexCapable value) {
        this._timeDivisionMultiplexCapable = value;
        return this;
    }

    public InterfaceSwitchingCapabilitiesBuilder addAugmentation(Class<? extends Augmentation<InterfaceSwitchingCapabilities>> augmentationType, Augmentation<InterfaceSwitchingCapabilities> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InterfaceSwitchingCapabilities>>, Augmentation<InterfaceSwitchingCapabilities>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public InterfaceSwitchingCapabilitiesBuilder removeAugmentation(Class<? extends Augmentation<InterfaceSwitchingCapabilities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InterfaceSwitchingCapabilities build() {
        return new InterfaceSwitchingCapabilitiesImpl(this);
    }

    private static final class InterfaceSwitchingCapabilitiesImpl
    implements InterfaceSwitchingCapabilities {
        private final Short _encoding;
        private final List<MaxLspBandwidth> _maxLspBandwidth;
        private final PacketSwitchCapable _packetSwitchCapable;
        private final SwitchingCapabilities _switchingCapability;
        private final TimeDivisionMultiplexCapable _timeDivisionMultiplexCapable;
        private final InterfaceSwitchingCapabilitiesKey key;
        private Map<Class<? extends Augmentation<InterfaceSwitchingCapabilities>>, Augmentation<InterfaceSwitchingCapabilities>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        InterfaceSwitchingCapabilitiesImpl(InterfaceSwitchingCapabilitiesBuilder base) {
            this.key = base.key() != null ? base.key() : new InterfaceSwitchingCapabilitiesKey(base.getSwitchingCapability());
            this._switchingCapability = this.key.getSwitchingCapability();
            this._encoding = base.getEncoding();
            this._maxLspBandwidth = base.getMaxLspBandwidth();
            this._packetSwitchCapable = base.getPacketSwitchCapable();
            this._timeDivisionMultiplexCapable = base.getTimeDivisionMultiplexCapable();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<InterfaceSwitchingCapabilities> getImplementedInterface() {
            return InterfaceSwitchingCapabilities.class;
        }

        @Override
        public InterfaceSwitchingCapabilitiesKey key() {
            return this.key;
        }

        @Override
        public Short getEncoding() {
            return this._encoding;
        }

        @Override
        public List<MaxLspBandwidth> getMaxLspBandwidth() {
            return this._maxLspBandwidth;
        }

        @Override
        public PacketSwitchCapable getPacketSwitchCapable() {
            return this._packetSwitchCapable;
        }

        @Override
        public SwitchingCapabilities getSwitchingCapability() {
            return this._switchingCapability;
        }

        @Override
        public TimeDivisionMultiplexCapable getTimeDivisionMultiplexCapable() {
            return this._timeDivisionMultiplexCapable;
        }

        public <E$$ extends Augmentation<InterfaceSwitchingCapabilities>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._encoding);
            result = 31 * result + Objects.hashCode(this._maxLspBandwidth);
            result = 31 * result + Objects.hashCode(this._packetSwitchCapable);
            result = 31 * result + Objects.hashCode((Object)this._switchingCapability);
            result = 31 * result + Objects.hashCode(this._timeDivisionMultiplexCapable);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InterfaceSwitchingCapabilities.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InterfaceSwitchingCapabilities other = (InterfaceSwitchingCapabilities)obj;
            if (!Objects.equals(this._encoding, other.getEncoding())) {
                return false;
            }
            if (!Objects.equals(this._maxLspBandwidth, other.getMaxLspBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._packetSwitchCapable, other.getPacketSwitchCapable())) {
                return false;
            }
            if (!Objects.equals((Object)this._switchingCapability, (Object)other.getSwitchingCapability())) {
                return false;
            }
            if (!Objects.equals(this._timeDivisionMultiplexCapable, other.getTimeDivisionMultiplexCapable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InterfaceSwitchingCapabilitiesImpl otherImpl = (InterfaceSwitchingCapabilitiesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InterfaceSwitchingCapabilities>>, Augmentation<InterfaceSwitchingCapabilities>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"InterfaceSwitchingCapabilities");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_encoding", (Object)this._encoding);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxLspBandwidth", this._maxLspBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_packetSwitchCapable", (Object)this._packetSwitchCapable);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_switchingCapability", (Object)((Object)this._switchingCapability));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_timeDivisionMultiplexCapable", (Object)this._timeDivisionMultiplexCapable);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

