/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes.SrlgValues;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes.SrlgValuesKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrlgValuesBuilder
implements Builder<SrlgValues> {
    private Long _srlgValue;
    private SrlgValuesKey key;
    Map<Class<? extends Augmentation<SrlgValues>>, Augmentation<SrlgValues>> augmentation = Collections.emptyMap();

    public SrlgValuesBuilder() {
    }

    public SrlgValuesBuilder(SrlgValues base) {
        Map aug;
        this.key = base.key();
        this._srlgValue = base.getSrlgValue();
        if (base instanceof SrlgValuesImpl) {
            SrlgValuesImpl impl = (SrlgValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SrlgValues>>, Augmentation<SrlgValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SrlgValues>>, Augmentation<SrlgValues>>(aug);
        }
    }

    public SrlgValuesKey key() {
        return this.key;
    }

    public Long getSrlgValue() {
        return this._srlgValue;
    }

    public <E$$ extends Augmentation<SrlgValues>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SrlgValuesBuilder withKey(SrlgValuesKey key) {
        this.key = key;
        return this;
    }

    private static void checkSrlgValueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public SrlgValuesBuilder setSrlgValue(Long value) {
        if (value != null) {
            SrlgValuesBuilder.checkSrlgValueRange(value);
        }
        this._srlgValue = value;
        return this;
    }

    public SrlgValuesBuilder addAugmentation(Class<? extends Augmentation<SrlgValues>> augmentationType, Augmentation<SrlgValues> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SrlgValues>>, Augmentation<SrlgValues>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SrlgValuesBuilder removeAugmentation(Class<? extends Augmentation<SrlgValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SrlgValues build() {
        return new SrlgValuesImpl(this);
    }

    private static final class SrlgValuesImpl
    implements SrlgValues {
        private final Long _srlgValue;
        private final SrlgValuesKey key;
        private Map<Class<? extends Augmentation<SrlgValues>>, Augmentation<SrlgValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SrlgValuesImpl(SrlgValuesBuilder base) {
            this.key = base.key() != null ? base.key() : new SrlgValuesKey(base.getSrlgValue());
            this._srlgValue = this.key.getSrlgValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SrlgValues> getImplementedInterface() {
            return SrlgValues.class;
        }

        @Override
        public SrlgValuesKey key() {
            return this.key;
        }

        @Override
        public Long getSrlgValue() {
            return this._srlgValue;
        }

        public <E$$ extends Augmentation<SrlgValues>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._srlgValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrlgValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrlgValues other = (SrlgValues)obj;
            if (!Objects.equals(this._srlgValue, other.getSrlgValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrlgValuesImpl otherImpl = (SrlgValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SrlgValues>>, Augmentation<SrlgValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"SrlgValues");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srlgValue", (Object)this._srlgValue);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

