/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.MaxLspBandwidth;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.MaxLspBandwidthKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MaxLspBandwidthBuilder
implements Builder<MaxLspBandwidth> {
    private BigDecimal _bandwidth;
    private Short _priority;
    private MaxLspBandwidthKey key;
    Map<Class<? extends Augmentation<MaxLspBandwidth>>, Augmentation<MaxLspBandwidth>> augmentation = Collections.emptyMap();

    public MaxLspBandwidthBuilder() {
    }

    public MaxLspBandwidthBuilder(MaxLspBandwidth base) {
        Map aug;
        this.key = base.key();
        this._priority = base.getPriority();
        this._bandwidth = base.getBandwidth();
        if (base instanceof MaxLspBandwidthImpl) {
            MaxLspBandwidthImpl impl = (MaxLspBandwidthImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MaxLspBandwidth>>, Augmentation<MaxLspBandwidth>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MaxLspBandwidth>>, Augmentation<MaxLspBandwidth>>(aug);
        }
    }

    public MaxLspBandwidthKey key() {
        return this.key;
    }

    public BigDecimal getBandwidth() {
        return this._bandwidth;
    }

    public Short getPriority() {
        return this._priority;
    }

    public <E$$ extends Augmentation<MaxLspBandwidth>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public MaxLspBandwidthBuilder withKey(MaxLspBandwidthKey key) {
        this.key = key;
        return this;
    }

    public MaxLspBandwidthBuilder setBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._bandwidth = value;
        return this;
    }

    private static void checkPriorityRange(short value) {
        if (value >= 0 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..7]]", (int)value);
    }

    public MaxLspBandwidthBuilder setPriority(Short value) {
        if (value != null) {
            MaxLspBandwidthBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    public MaxLspBandwidthBuilder addAugmentation(Class<? extends Augmentation<MaxLspBandwidth>> augmentationType, Augmentation<MaxLspBandwidth> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MaxLspBandwidth>>, Augmentation<MaxLspBandwidth>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MaxLspBandwidthBuilder removeAugmentation(Class<? extends Augmentation<MaxLspBandwidth>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MaxLspBandwidth build() {
        return new MaxLspBandwidthImpl(this);
    }

    private static final class MaxLspBandwidthImpl
    implements MaxLspBandwidth {
        private final BigDecimal _bandwidth;
        private final Short _priority;
        private final MaxLspBandwidthKey key;
        private Map<Class<? extends Augmentation<MaxLspBandwidth>>, Augmentation<MaxLspBandwidth>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        MaxLspBandwidthImpl(MaxLspBandwidthBuilder base) {
            this.key = base.key() != null ? base.key() : new MaxLspBandwidthKey(base.getPriority());
            this._priority = this.key.getPriority();
            this._bandwidth = base.getBandwidth();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<MaxLspBandwidth> getImplementedInterface() {
            return MaxLspBandwidth.class;
        }

        @Override
        public MaxLspBandwidthKey key() {
            return this.key;
        }

        @Override
        public BigDecimal getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public Short getPriority() {
            return this._priority;
        }

        public <E$$ extends Augmentation<MaxLspBandwidth>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._priority);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MaxLspBandwidth.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MaxLspBandwidth other = (MaxLspBandwidth)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MaxLspBandwidthImpl otherImpl = (MaxLspBandwidthImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MaxLspBandwidth>>, Augmentation<MaxLspBandwidth>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MaxLspBandwidth");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bandwidth", (Object)this._bandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_priority", (Object)this._priority);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

