/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.SrlgAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes.InterfaceSwitchingCapabilities;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes.SrlgValues;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.Srlg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrlgBuilder
implements Builder<Srlg> {
    private List<InterfaceSwitchingCapabilities> _interfaceSwitchingCapabilities;
    private Integer _linkProtectionType;
    private List<SrlgValues> _srlgValues;
    Map<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>> augmentation = Collections.emptyMap();

    public SrlgBuilder() {
    }

    public SrlgBuilder(SrlgAttributes arg) {
        this._interfaceSwitchingCapabilities = arg.getInterfaceSwitchingCapabilities();
        this._srlgValues = arg.getSrlgValues();
        this._linkProtectionType = arg.getLinkProtectionType();
    }

    public SrlgBuilder(Srlg base) {
        Map aug;
        this._interfaceSwitchingCapabilities = base.getInterfaceSwitchingCapabilities();
        this._linkProtectionType = base.getLinkProtectionType();
        this._srlgValues = base.getSrlgValues();
        if (base instanceof SrlgImpl) {
            SrlgImpl impl = (SrlgImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrlgAttributes) {
            this._interfaceSwitchingCapabilities = ((SrlgAttributes)arg).getInterfaceSwitchingCapabilities();
            this._srlgValues = ((SrlgAttributes)arg).getSrlgValues();
            this._linkProtectionType = ((SrlgAttributes)arg).getLinkProtectionType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.SrlgAttributes]");
    }

    public List<InterfaceSwitchingCapabilities> getInterfaceSwitchingCapabilities() {
        return this._interfaceSwitchingCapabilities;
    }

    public Integer getLinkProtectionType() {
        return this._linkProtectionType;
    }

    public List<SrlgValues> getSrlgValues() {
        return this._srlgValues;
    }

    public <E$$ extends Augmentation<Srlg>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SrlgBuilder setInterfaceSwitchingCapabilities(List<InterfaceSwitchingCapabilities> values) {
        this._interfaceSwitchingCapabilities = values;
        return this;
    }

    private static void checkLinkProtectionTypeRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public SrlgBuilder setLinkProtectionType(Integer value) {
        if (value != null) {
            SrlgBuilder.checkLinkProtectionTypeRange(value);
        }
        this._linkProtectionType = value;
        return this;
    }

    public SrlgBuilder setSrlgValues(List<SrlgValues> values) {
        this._srlgValues = values;
        return this;
    }

    public SrlgBuilder addAugmentation(Class<? extends Augmentation<Srlg>> augmentationType, Augmentation<Srlg> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SrlgBuilder removeAugmentation(Class<? extends Augmentation<Srlg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Srlg build() {
        return new SrlgImpl(this);
    }

    private static final class SrlgImpl
    implements Srlg {
        private final List<InterfaceSwitchingCapabilities> _interfaceSwitchingCapabilities;
        private final Integer _linkProtectionType;
        private final List<SrlgValues> _srlgValues;
        private Map<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SrlgImpl(SrlgBuilder base) {
            this._interfaceSwitchingCapabilities = base.getInterfaceSwitchingCapabilities();
            this._linkProtectionType = base.getLinkProtectionType();
            this._srlgValues = base.getSrlgValues();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Srlg> getImplementedInterface() {
            return Srlg.class;
        }

        @Override
        public List<InterfaceSwitchingCapabilities> getInterfaceSwitchingCapabilities() {
            return this._interfaceSwitchingCapabilities;
        }

        @Override
        public Integer getLinkProtectionType() {
            return this._linkProtectionType;
        }

        @Override
        public List<SrlgValues> getSrlgValues() {
            return this._srlgValues;
        }

        public <E$$ extends Augmentation<Srlg>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceSwitchingCapabilities);
            result = 31 * result + Objects.hashCode(this._linkProtectionType);
            result = 31 * result + Objects.hashCode(this._srlgValues);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Srlg.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Srlg other = (Srlg)obj;
            if (!Objects.equals(this._interfaceSwitchingCapabilities, other.getInterfaceSwitchingCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._linkProtectionType, other.getLinkProtectionType())) {
                return false;
            }
            if (!Objects.equals(this._srlgValues, other.getSrlgValues())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrlgImpl otherImpl = (SrlgImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Srlg>>, Augmentation<Srlg>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Srlg");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_interfaceSwitchingCapabilities", this._interfaceSwitchingCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_linkProtectionType", (Object)this._linkProtectionType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srlgValues", this._srlgValues);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

