/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.node.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.node.attributes.Ipv6LocalAddress;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.node.attributes.Ipv6LocalAddressKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6LocalAddressBuilder
implements Builder<Ipv6LocalAddress> {
    private Ipv6Prefix _ipv6Prefix;
    private Short _prefixOption;
    private Ipv6LocalAddressKey key;
    Map<Class<? extends Augmentation<Ipv6LocalAddress>>, Augmentation<Ipv6LocalAddress>> augmentation = Collections.emptyMap();

    public Ipv6LocalAddressBuilder() {
    }

    public Ipv6LocalAddressBuilder(Ipv6LocalAddress base) {
        Map aug;
        this.key = base.key();
        this._ipv6Prefix = base.getIpv6Prefix();
        this._prefixOption = base.getPrefixOption();
        if (base instanceof Ipv6LocalAddressImpl) {
            Ipv6LocalAddressImpl impl = (Ipv6LocalAddressImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6LocalAddress>>, Augmentation<Ipv6LocalAddress>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6LocalAddress>>, Augmentation<Ipv6LocalAddress>>(aug);
        }
    }

    public Ipv6LocalAddressKey key() {
        return this.key;
    }

    public Ipv6Prefix getIpv6Prefix() {
        return this._ipv6Prefix;
    }

    public Short getPrefixOption() {
        return this._prefixOption;
    }

    public <E$$ extends Augmentation<Ipv6LocalAddress>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public Ipv6LocalAddressBuilder withKey(Ipv6LocalAddressKey key) {
        this.key = key;
        return this;
    }

    public Ipv6LocalAddressBuilder setIpv6Prefix(Ipv6Prefix value) {
        this._ipv6Prefix = value;
        return this;
    }

    private static void checkPrefixOptionRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public Ipv6LocalAddressBuilder setPrefixOption(Short value) {
        if (value != null) {
            Ipv6LocalAddressBuilder.checkPrefixOptionRange(value);
        }
        this._prefixOption = value;
        return this;
    }

    public Ipv6LocalAddressBuilder addAugmentation(Class<? extends Augmentation<Ipv6LocalAddress>> augmentationType, Augmentation<Ipv6LocalAddress> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6LocalAddress>>, Augmentation<Ipv6LocalAddress>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Ipv6LocalAddressBuilder removeAugmentation(Class<? extends Augmentation<Ipv6LocalAddress>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6LocalAddress build() {
        return new Ipv6LocalAddressImpl(this);
    }

    private static final class Ipv6LocalAddressImpl
    implements Ipv6LocalAddress {
        private final Ipv6Prefix _ipv6Prefix;
        private final Short _prefixOption;
        private final Ipv6LocalAddressKey key;
        private Map<Class<? extends Augmentation<Ipv6LocalAddress>>, Augmentation<Ipv6LocalAddress>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        Ipv6LocalAddressImpl(Ipv6LocalAddressBuilder base) {
            this.key = base.key() != null ? base.key() : new Ipv6LocalAddressKey(base.getIpv6Prefix());
            this._ipv6Prefix = this.key.getIpv6Prefix();
            this._prefixOption = base.getPrefixOption();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Ipv6LocalAddress> getImplementedInterface() {
            return Ipv6LocalAddress.class;
        }

        @Override
        public Ipv6LocalAddressKey key() {
            return this.key;
        }

        @Override
        public Ipv6Prefix getIpv6Prefix() {
            return this._ipv6Prefix;
        }

        @Override
        public Short getPrefixOption() {
            return this._prefixOption;
        }

        public <E$$ extends Augmentation<Ipv6LocalAddress>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv6Prefix);
            result = 31 * result + Objects.hashCode(this._prefixOption);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6LocalAddress.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6LocalAddress other = (Ipv6LocalAddress)obj;
            if (!Objects.equals(this._ipv6Prefix, other.getIpv6Prefix())) {
                return false;
            }
            if (!Objects.equals(this._prefixOption, other.getPrefixOption())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6LocalAddressImpl otherImpl = (Ipv6LocalAddressImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6LocalAddress>>, Augmentation<Ipv6LocalAddress>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Ipv6LocalAddress");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipv6Prefix", (Object)this._ipv6Prefix);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_prefixOption", (Object)this._prefixOption);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

