#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Backup all mountpoints from RestConf configuration datastore.
# And then generate a file named "mountpoint_$host" in current path.
# The file can be used to recover all mountpoints on any
# NetConf (version since ODL Oxygen-sr1) by running recover.sh.
#
# Parameters:
# $1 host, Restconf IP address, Default value localhost.
#
# Versions:
# v1.4.13 2020-09-04 create
# v1.4.16 2020-09-29 add annotation
# v1.4.18 2020-11-20 modify output file with line number

if [ "$1" == "" ]; then
    host="localhost"
else
    host=$1
fi
filename=mountpoint_$host
curl -s http://admin:admin@$host:8181/restconf/config/network-topology:network-topology/topology/topology-netconf > $filename
count=`grep -c 'topology' $filename`
if [ "$count" == "0" ]; then
    echo 'RestConf is not ready. Please check netconf status.'
    exit -1
fi
sed -i '1s/{"node-id/\n{"node-id/g' $filename
sed -i '1d' $filename
sed -i '1,$s/},$/}/g' $filename
sed -i '$s/]}]}/\n/g' $filename

exit 0
