#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
#
# Description:
# Close netconf session from restconf by some id of raisecom-equipment. 
# Input parameters are case sensitive.
#
# Versions:
# v1.4.17 2020-10-27 create
# v1.4.18 2020-11-19 support netconf_id and query device from inventory

export ipv4_expr='^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$'
export port_expr='^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$'

host=
checkIp=`echo $host | egrep $ipv4_expr`
while [ -z "$checkIp" -a "$host" != "localhost" ]
do
    read -p "Input North VIP SDNC(IPv4): " host
    checkIp=`echo $host | egrep $ipv4_expr`
done

idType=
while [ -z "$idType" ]
do
    read -p "Input target id type of device(netconfid/loid/sn/pppoe/mac/ip/deviceid): " idType
    idType=`echo "$idType" | egrep '^netconfid$|^loid$|^sn$|^pppoe$|^mac$|^ip$|^deviceid$'`
done

read -p "Input $idType of device: " targetId

nodeId=
case $idType in
    "netconfid")
        nodeId="$targetId"
        ;;
    "loid")
        nodeId=`curl -s http://$host:60175/inventory/deviceinfo/loid/$targetId | grep -Po '(?<="netconf_id":")[^"]*'`
        ;;
    "sn")
        nodeId=`curl -s http://$host:60175/inventory/singledevice?sn=$targetId | grep -Po '(?<="netconf_id":")[^"]*'`
        ;;
    "mac")
        targetId=`echo $targetId | sed 's/:/%3A/g'`
        nodeId=`curl -s http://$host:60175/inventory/singledevice?mac=$targetId | grep -Po '(?<="netconf_id":")[^"]*'`
        ;;
    "pppoe")
        nodeId=`curl -s http://$host:60175/inventory/singledevice?pppoe_account=$targetId | grep -Po '(?<="netconf_id":")[^"]*'`
        ;;
    "ip")
        nodeId=`curl -s http://$host:60175/inventory/deviceinfo?ip=$targetId | grep -Po '(?<="netconf_id":")[^"]*'`
        ;;
    "deviceid")
        nodeId=`curl -s http://$host:60175/inventory/deviceid/$targetId | grep -Po '(?<="netconf_id":")[^"]*'`
        ;;
    *)
        echo "Unknown idType $idType. Exit."
        exit -1
        ;;
esac

[ -z $nodeId ] && echo "No such device: $idType=$targetId." && exit 0

nodeIp=`curl -s http://$host:60216/cluster/netconfroute/$nodeId | grep -Po '(?<="nodeIp":")[^"]*'`
[ -z $nodeIp ] && echo "Device is alread offline on cluster. $idType=$targetId. netconfId=$nodeId. nodeIp=$nodeIp" && exit 0

#devices=`curl -s http://admin:admin@$host:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf?depth=3 | grep -Po '(?<="node-id":")[^"]*'`
#for device in $devices
#do
#    id=`curl -s http://admin:admin@$host:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf/node/$device/yang-ext:mount/raisecom-equipment:managed-element?depth=2 | grep -Po "(?<=\"$idType\":\")[^\"]*"`
#    [ "$id" == "$targetId" ] && nodeId=$device && break
#done

yumaSupport=`curl -s http://admin:admin@$nodeIp:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf/node/$nodeId | grep -c yuma-netconf`
if [ "$yumaSupport" -gt 0 ]; then
    curl -X POST http://admin:admin@$nodeIp:8181/restconf/operations/network-topology:network-topology/topology/topology-netconf/node/$nodeId/yang-ext:mount/yuma-netconf:close-session
else
    curl -X POST http://admin:admin@$nodeIp:8181/restconf/operations/network-topology:network-topology/topology/topology-netconf/node/$nodeId/yang-ext:mount/ietf-netconf:close-session
fi
echo "Close session of device: $idType=$targetId. netconfId=$nodeId. nodeIp=$nodeIp"

exit 0
