#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
# $1 host: IP address of master node. 
#
# Description:
# Find all the differences of online devices queried from netconf/cluster/inventory.
#
# Versions:
# v1.4.17 2020-10-12 create
# v1.4.17 2020-11-05 support query from inventory
# v1.4.19 2020-12-03 remove all duplicated devices in the results of cluster and inventory

echo "Executing $0 ..."
echo "Description:"
echo -e "Find all the differences of online devices queried from netconf and cluster.\n"

ipv4_expr='^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$'
port_expr='^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$'

host=$1
checkIp=`echo $host | egrep $ipv4_expr`
while [ -z "$checkIp" -a "$host" != "localhost" ]
do
    read -p "Input host of master(IPv4): " host
    checkIp=`echo $host | egrep $ipv4_expr`
done

dir=$(cd `dirname $0`; pwd)
filenameCluster=$dir/logs/online_dev_cluster.log
filenameNetconf=$dir/logs/online_dev_netconf.log
filenameInv=$dir/logs/online_dev_inventory.log
outClusterIds=$dir/logs/clusterIds
outNetconfIds=$dir/logs/netconfIds
outInvIds=$dir/logs/invIds

outputFile=$dir/logs/diff_cluster_netconf.log
outputFile2=$dir/logs/diff_cluster_inventory.log

bash filterOnline.sh $host cluster
bash filterOnline.sh $host netconf
bash filterOnline.sh $host inventory

grep -Po '(?<="netconfId":")[^"]*' $filenameCluster | sort | uniq > $outClusterIds
grep connected $filenameNetconf | grep -Po '(?<="node-id":")[^"]*' | sort > $outNetconfIds
grep 'status":"1"' $filenameInv | grep -Po '(?<="netconf_id":")[^"]*' | sort | uniq > $outInvIds

echo "$(wc -l $outNetconfIds) online devices on netconf"
echo "$(wc -l $outClusterIds) online devices on cluster"
echo "$(wc -l $outInvIds) online devices on inventory"

diff $outClusterIds $outNetconfIds > $outputFile
echo -e "Please check $outputFile.\n"

diff $outClusterIds $outInvIds > $outputFile2
echo -e "Please check $outputFile2.\n"

rm -f $outClusterIds
rm -f $outNetconfIds
rm -f $outInvIds

exit 0
