#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
# $1 host: IP address of any cluster node.
#
# Description:
# Filter all connecting device on RestConf and show their node-id
#
# Versions:
# v1.4.17 2020-10-30 create
# v1.4.18 2020-11-18 show information of connecting devices in logs/offline_dev.log

ipv4_expr='^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$'
port_expr='^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$'

mkdir -p logs
host=$1
checkIp=`echo $host | egrep $ipv4_expr`
while [ -z "$checkIp" -a "$host" != "localhost" ]
do
    read -p "Input host of netconf(IPv4): " host
    checkIp=`echo $host | egrep $ipv4_expr`
done

curl -s http://admin:admin@$host:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf?depth=3 | sed '1,$s/,{\"node-id/\n{\"node-id/g' | grep -iv 'Connected' > logs/offline_dev.log

exit 0

