#!/bin/bash
# Author songrq@raisecom.com
# 
# Description
# Search all online devices whose reboot-type is factoryRestore and write them into ./logs/factoreRestore.txt
# v1.4.24

rm -f factoryRestore.txt
netconfIds=`grep connected diagnosis/logs/online_dev_netconf.log | grep -Po '(?<=node-id":")[^"]*'`
for netconfId in $netconfIds
do
    status=`curl -s http://admin:admin@localhost:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf/node/$netconfId/yang-ext:mount/raisecom-equipment:managed-element | grep -Po '(?<=reboot-type":")[^"]*'`
    sn=`curl -s http://localhost:60175/inventory/singledevice?netconf_id=$netconfId | grep -Po '(?<="sn":")[^"]*'`
    echo "netconfId=$netconfId, sn=$sn, status=$status" >> factoryRestore.txt
    sleep 0.5
done
exit 0

