#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
# $1 search range: all/last
#
# Description:
# Search all offline callhome devices in $log_path and write them into ./logs/offline_dev.log
#
# Versions:
# v1.4.16 2020-09-28

range=$1
[ "$1" != "all" -a "$1" != "last" ] && range=last

dir=$(cd `dirname $0`; pwd)
log_path=/var/log/msp/sdnc/netconf
if [ ! -d "$dir/logs" ]; then
    mkdir -p $dir/logs
fi
output_path=$dir/logs/offline_dev.log

rm -f $output_path

if [ "$range" == "all" ]; then
    logs=`ls $log_path | grep gz | grep netconf`
    for log in $logs
    do
        zgrep netconf_online $log_path/$log | grep delete | awk '{print $1, $25}' | sed 's/message=//g' >> $output_path
    done
fi
grep netconf_online $log_path/netconf.log | grep delete | awk '{print $1, $25}' | sed 's/message=//g' >> $output_path

last_offline=`tail -1 $output_path | awk '{print $1}'`
if [ "$last_offline" != "" ]; then
    last_time=`date -d $last_offline +%s`
    now=`date +%s`
    time=$(($now-$last_time))
    if [ "$time" -gt 60 ]; then
        echo "The last offline event happened before $(($time/60)) minutes."
    else
        echo "The last offline event happened before $time seconds."
    fi
else
    echo "No offline event happened. $range"
fi

exit 0
