#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
# $1 inputFile
#
# Description:
# Convert context from native code to ascii
#
# Versions:
# v1.4.17 2020-10-10 create
# v1.4.21 2021-01-18 use absolute path

dir=`cd $(dirname $0); pwd`
mkdir -p $dir/logs

inputFile=$1
outputFile=$dir/logs/context
tempFile=$dir/logs/temp
rm -f $outputFile

grep -o '[[:xdigit:]]\{2\}' $inputFile | while read byte; do echo "\u00$byte"; done | tr -d '\n' > $tempFile

$JAVA_HOME/bin/native2ascii -reverse $tempFile $outputFile
rm -f $tempFile
echo $outputFile

exit 0
