#!/bin/bash
# Author songrq@raisecom.com
#
# Parameters:
#
# Description:
# Used to generate mountpoint metadata for recover.sh.
#
# Versions:
# v1.4.17 2020-10-10 create

mountpoint_base={\"netconf-node-topology:reconnect-on-changed-schema\":false,\"netconf-node-topology:concurrent-rpc-limit\":0,\"netconf-node-topology:tcp-only\":false,\"netconf-node-topology:max-connection-attempts\":0,\"netconf-node-topology:keepalive-delay\":300,\"netconf-node-topology:schemaless\":false,\"netconf-node-topology:schema-cache-directory\":\"schema\",\"netconf-node-topology:default-request-timeout-millis\":60000,\"netconf-node-topology:sleep-factor\":1,\"netconf-node-topology:connection-timeout-millis\":20000,\"netconf-node-topology:actor-response-wait-time\":5,\"netconf-node-topology:between-attempts-timeout-millis\":60000,

ipv4_expr='^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$'
port_expr='^([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])$'

read -p "Input the filename of ips: " inputFilename
while [ ! -f $inputFilename ]
do
    read -p "Error. file $inputFilename does not exist. Input again: " inputFilename
done
ipList=`cat $inputFilename | awk '{print $1}'`

read -p "Input the port: " port
port=`echo $port | egrep $port_expr`
while [ -z "$port" ]
do
    echo "Invalid port. Out of range 1-65535."
    read -p "Input the port(1-65535): " port
    port=`echo $port | egrep $port_expr`
done
echo "port=$port"

read -p "Input the username: " username

read -p "Input the password: " password
echo ""

dev_count=0
filename=mountpoint_localhost
rm -f $filename

for ip in $ipList
do
    if [ -z $(echo $ip | egrep $ipv4_expr) ]; then
        echo "Warning: invalid ip $ip"
        continue
    fi
    append="\"node-id\":\"$ip\",\"netconf-node-topology:host\":\"$ip\",\"netconf-node-topology:port\":$port,\"netconf-node-topology:username\":\"$username\",\"netconf-node-topology:password\":\"$password\"}"
    echo $mountpoint_base | sed "s#\$#$append#g" >> $filename
    dev_count=`expr $dev_count + 1`
done

echo -e "\n$dev_count mountpoints to recover."
bash recover.sh $filename single

exit 0
