#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Check whether NetConf process running under the current path.
# If so, just exit.
# Otherwise, kill all NetConf invalid_pids running under the invalid path.
# Then start NetConf under the current path.
#
# Versions:
# v1.4.16 2020-09-29 add annotation

dir=$(cd `dirname $0`; pwd)
status=`curl -s -m 10 -w %{http_code} http://admin:admin@localhost:8181/restconf`
if [ "$status" == "204" ]; then
    echo "working"
    exit 0;
else
    echo `date +%Y-%m-%dT%H:%M:%S` "Restconf is not ready $status" | tee -a $dir/logexam
    exit -1;
fi
