#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Recover all mountpoints from a file generated by backup.sh.
# This Shell could be used since ODL NetConf Oxygen-sr1.
#
# Parameters:
# $1 filename of mountPoints.
# $2 mode: single/cluster. Default value "cluster".
#
# Versions:
# v1.4.16 2020-09-30 add annotation

[ ! -f "$1" ] && echo "Please input filename of mountpoints." && exit -1

if [ -n "$2" ]; then
    mode=$2
else
    mode="cluster"
fi
cat $1 | while read line
do
    nodeId=`echo $line | grep -Po '(?<="node-id":")[^"]*'`
    echo -e "\ncreate device $nodeId"
    if [ $mode == "single" ]; then
        curl -X POST http://admin:admin@localhost:8181/restconf/operations/netconf-node-topology:create-device -H 'Content-type:application/json' -d "{\"input\":$line}"
    else
        curl -X POST http://localhost:60216/cluster/mountpoint -H 'Content-type:application/json' -d "{\"input\":$line}" > /dev/null
    fi
    sleep 1
done

exit 0
