#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Delete all mountpoints stored in a file generated from backup.sh.
# Take care to use this Shell!
#
# Versions:
# v1.4.16 2020-09-29 add annotation

[ ! -f "$1" ] && echo "Please input filename of mountpoints." && exit -1

if [ -n "$2" ]; then
    mode=$2
else
    mode="cluster"
fi

cat $1 | while read line
do
    nodeId=`echo $line | grep -Po '(?<="node-id":")[^"]*'`
    echo -e "\n$nodeId"
    if [ "$mode" == "single" ]; then
        curl -s -X POST http://admin:admin@localhost:8181/restconf/operations/netconf-node-topology:delete-device -H 'Content-type:application/json' -d "{\"input\":{\"node-id\":\"$nodeId\"}}"
    else
        curl -s -X DELETE http://localhost:60216/cluster/mountpoint/$nodeId?force=true
    fi
    sleep 1
done

exit 0
