#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Check whether NetConf process running under the current path.
# If so, just exit.
# Otherwise, kill all NetConf processes running under the invalid paths.
# Then start NetConf under the current path.
#
# Versions:
# v1.4.16 2020-09-29 add annotation

dir=$(cd `dirname $0`; pwd)
log=$dir/logstart
echo `date +%Y-%m-%dT%H:%M:%S` "NetConf $0 is invoked." >> $log

# Create log path
log_path=/var/log/nms/sdnc/netconf
mkdir -p $log_path

running_pid=`ps -ef | grep $dir | grep org.apache.karaf.main.Main | grep -v grep | awk '{print $2}'`
if [ "$running_pid" != "" ]; then
    echo `date +%Y-%m-%dT%H:%M:%S` "NetConf $running_pid is running." | tee -a $log
    exit 0
fi

invalid_pids=`ps -ef | grep netconf | grep org.apache.karaf.main.Main | grep -v grep | awk '{print $2}'`
echo `date +%Y-%m-%dT%H:%M:%S` "invalid_pids=$invalid_pids" | tee -a $log

for invalid_pid in $invalid_pids
do
    echo `date +%Y-%m-%dT%H:%M:%S` "Kil NetConf $invalid_pid running under the invalid path." | tee -a $log
    kill -9 $invalid_pid
done

# Start NetConf
$dir/bin/start clean debug
echo `date +%Y-%m-%dT%H:%M:%S` "Starting NetConf..." | tee -a $log

exit 0