#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Show the NetConf/TCP connection status of all devices.
#
# Parameters:
# $1 type, netconf/tcp
# $2 host, IPv4 address
#
# Versions:
# v1.4.16 2020-09-29

if [ -n "$1" ]; then
    type=$1
else
    type="netconf"
fi
if [ -n "$2" ]; then
    host=$2
else
    host="localhost"
fi
echo `date +%Y-%m-%dT%H:%M:%S` "host=$host type=$type" >> online_statistics.log
if [ "$type" == "netconf" ]; then
    curl -s http://admin:admin@$host:8181/restconf/operational/network-topology:network-topology/topology/topology-netconf?depth=3 | grep -Po '(?<=status":")[^"]*' | sort | uniq -c | tee -a online_statistics.log
else
    netstat -an | egrep '[0-9]:6666|[0-9]:830' | awk '{print $6}' | sort | uniq -c | tee -a online_statistics.log
fi

exit 0
