#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Check whether NetConf process is running.
# If so, kill all NetConf processes.
# Otherwise, just exit.
#
# Versions:
# v1.4.16 2020-09-29 add annotation

dir=$(cd `dirname $0`; pwd)
log=$dir/logstart
echo `date +%Y-%m-%dT%H:%M:%S` "NetConf $0 is invoked." >> $log

pids=`ps -ef | grep netconf | grep org.apache.karaf.main.Main | grep -v grep | awk '{print $2}'`
for pid in $pids
do
    echo `date +%Y-%m-%dT%H:%M:%S` "Kill NetConf $pid." | tee -a $log
    kill -9 $pid
done

echo `date +%Y-%m-%dT%H:%M:%S` "All netconf processes have been killed." | tee -a $log

exit 0
