#!/bin/bash
# Author songruiqi@raisecom.com
#
# Description:
# Kill all netconf processes.
#
# Versions:
# v1.4.16 2020-09-29 add annotation
# v1.4.18 2020-11-20 kill all netconf processes

dir=$(cd `dirname $0`; pwd)
echo `date +%Y-%m-%dT%H:%M:%S` "NetConf $0 is invoked." | tee -a $dir/logstart

pids=`ps -ef | grep netconf | grep org.apache.karaf.main.Main | grep -v grep | awk '{print $2}'`
for pid in $pids
do
    echo `date +%Y-%m-%dT%H:%M:%S` "Kill NetConf $pid." | tee -a $log
    kill -9 $pid
done

echo `date +%Y-%m-%dT%H:%M:%S` "All netconf processes have been killed." | tee -a $log

exit 0
