const express = require('express');
const fs = require('fs');
const path = require('path');
const morgan = require('morgan');
const moment = require('moment-timezone');

const app = express();
const port = 55080;
const uploadDir = '/cpe-r/p/*';  // Defina o diretório de upload conforme necessário

// Middleware para registrar logs
const logStream = fs.createWriteStream('/var/log/tr143.log', { flags: 'a' });

morgan.token('date', (req, res, tz) => {
  return moment().tz(tz).format('DD/MMM/YYYY:HH:mm:ss Z');
});

app.use(morgan(':remote-addr - :remote-user [:date[America/Sao_Paulo]] ":method :url HTTP/:http-version" :status :res[content-length] ":referrer" ":user-agent"', { stream: logStream }));

// Middleware para tratar upload de arquivos
app.use(express.raw({ type: '*/*', limit: '200mb' }));

// Verifica se o diretório de upload existe e cria se não existir
if (!fs.existsSync(uploadDir)) {
  fs.mkdirSync(uploadDir, { recursive: true });
}

// Função para tratar download de arquivos
const handleDownload = (req, res, fileName) => {
  const filePath = path.join(__dirname, fileName);
  res.download(filePath, (err) => {
    if (err) {
      res.status(500).send('Erro ao baixar o arquivo.');
    }
  });
};

// Rotas para download dos arquivos
app.get('/download.raw', (req, res) => {
  handleDownload(req, res, 'download.raw');
});

app.get('/download25.raw', (req, res) => {
  handleDownload(req, res, 'download25.raw');
});

app.get('/download50.raw', (req, res) => {
  handleDownload(req, res, 'download50.raw');
});

app.get('/download100.raw', (req, res) => {
  handleDownload(req, res, 'download100.raw');
});

app.get('/server.zip', (req, res) => {
  handleDownload(req, res, 'server.zip');
});



// Rota para upload do arquivo
app.put('/cpe-r/p/*', (req, res) => {
  const filePath = path.join(uploadDir, 'upload.raw');
  
  // Verifica se o corpo da requisição não está vazio
  if (!req.body || req.body.length === 0) {
    return res.status(400).send('Arquivo não pode estar vazio.');
  }

  fs.writeFile(filePath, req.body, (err) => {
    if (err) {
      console.error('Erro ao salvar o arquivo:', err);
      return res.status(500).send('Erro ao fazer upload do arquivo.');
    }

    res.status(201).send('Upload realizado com sucesso.');

    // Excluir o arquivo após 1 minuto
    setTimeout(() => {
      fs.unlink(filePath, (err) => {
        if (err) {
          console.error('Erro ao excluir o arquivo:', err);
        } else {
          console.log('Arquivo excluído:', filePath);
        }
      });
    }, 60000);
  });
});

// Inicia o servidor
app.listen(port, () => {
  console.log(`Servidor escutando na porta ${port}`);
});
